/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.recap;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.Sujeto;
import ec.gob.sri.dimm.ats.modelo.util.Constantes;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Establecimiento
extends Sujeto
implements Importable {
    private static final long serialVersionUID = -7165096025356786368L;
    public static final String C_PARTE_RELACIONADA = "descripcionEstablecimiento";
    private boolean parteRelacionada;

    public Establecimiento() {
        this.parteRelacionada = false;
    }

    public Establecimiento(String string, String string2, String txVentas) {
        super(string, string2, txVentas);
    }

    @Override
    public Establecimiento crearCopiaEdicion() {
        Establecimiento copia = new Establecimiento();
        copia.setTipoIdentificacion(super.getTipoIdentificacion());
        copia.setIdentificacion(super.getIdentificacion());
        copia.setDescripcionTipoIdentificacion(super.getDescripcionTipoIdentificacion());
        copia.setParteRelacionada(this.parteRelacionada);
        copia.setTipoProveedor(super.getTipoProveedor());
        copia.setRazonSocial(super.getRazonSocial());
        copia.setPropietario(this.propietario);
        return copia;
    }

    @Override
    public void actualizarInformacion(Sujeto copiaEdicion) {
        Establecimiento comprador = (Establecimiento)copiaEdicion;
        this.setParteRelacionada(comprador.parteRelacionada);
        this.setTipoProveedor(comprador.tipoProveedor);
        this.setRazonSocial(comprador.razonSocial);
        super.actualizarInformacion(copiaEdicion);
    }

    @Override
    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("establecimientoRecap");
        Element eValor = (Element)valorList.item(0);
        this.setTipoIdentificacion(UtilCatalogosATS.crearInstancia().obtenerTipoIdentificacionSecuencia("5", eValor.getTextContent().trim()));
        this.setDescripcionTipoIdentificacion(Constantes.CATALOGOS_SUJETO.get(this.getTipoIdentificacion()));
        valorList = elemento.getElementsByTagName("identificacionRecap");
        eValor = (Element)valorList.item(0);
        this.setIdentificacion(eValor.getTextContent().trim());
        if (Util.existeElementoImportar(elemento, "parteRelRec")) {
            valorList = elemento.getElementsByTagName("parteRelRec");
            eValor = (Element)valorList.item(0);
            this.setParteRelacionada(Util.importarBooleano(eValor));
        }
        if (Util.existeElementoImportar(elemento, "tipoEst")) {
            valorList = elemento.getElementsByTagName("tipoEst");
            eValor = (Element)valorList.item(0);
            this.setTipoProveedor(eValor.getTextContent().trim());
            this.setDescripcionTipoProveedor(UtilCatalogosATS.obtenerNombreDetalleCatalogo((String)"TIPOSIDPROV", (String)this.getTipoProveedor()));
        }
        if (Util.existeElementoImportar(elemento, "denoCliRecaps")) {
            valorList = elemento.getElementsByTagName("denoCliRecaps");
            eValor = (Element)valorList.item(0);
            this.setRazonSocial(eValor.getTextContent().trim());
        }
        return this;
    }

    @Override
    protected ResultadoValidacion validacionExtra(ResultadoValidacion resultado) {
        Periodo periodo = ((Iva)this.getRaizModelo()).periodo;
        return this.validarRazonSocialPorPeriodoYTipoIdentificacion(resultado, periodo);
    }

    private ResultadoValidacion validarRazonSocialPorPeriodoYTipoIdentificacion(ResultadoValidacion resultado, Periodo periodo) {
        if ("P".equals(this.getTipoIdentificacion()) && periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            if (StringUtil.isNullOrEmpty((String)this.getRazonSocial())) {
                return resultado.fallarValidacion("Debe registrar la raz\u00f3n social");
            }
            if (!this.validarFormatoRazonSocial()) {
                return resultado.fallarValidacion("La raz\u00f3n social del establecimiento  debe contener solo letras y n\u00fameros y m\u00ednimo 1 caracter");
            }
        }
        return resultado;
    }

    public boolean isParteRelacionada() {
        return this.parteRelacionada;
    }

    public String getParteRelacionada() {
        return this.parteRelacionada ? "SI" : "NO";
    }

    public void setParteRelacionada(boolean parteRelacionada) {
        boolean oldValue = this.parteRelacionada;
        this.parteRelacionada = parteRelacionada;
        this.firePropertyChange(C_PARTE_RELACIONADA, oldValue, this.parteRelacionada);
    }
}

